// Daniel Shiffman
// https://thecodingtrain.com/CodingChallenges/146-rendering-ray-casting.html
// https://youtu.be/vYgIKn7iDH8

// Rendering Ray Casting
// https://editor.p5js.org/codingtrain/sketches/yEzlR0_zq

class Particle {
  constructor() {
    this.fov = 45;
    this.pos = createVector(sceneW / 2, sceneH / 2);
    this.rays = [];
    this.heading = 0;
    for (let a = -this.fov / 2; a < this.fov / 2; a += 1) {
      this.rays.push(new Ray(this.pos, radians(a)));
    }
  }

  updateFOV(fov) {
    this.fov = fov;
    this.rays = [];
    for (let a = -this.fov / 2; a < this.fov / 2; a += 1) {
      this.rays.push(new Ray(this.pos, radians(a) + this.heading));
    }
  }

  rotate(angle) {
    this.heading += angle;
    let index = 0;
    for (let a = -this.fov / 2; a < this.fov / 2; a += 1) {
      this.rays[index].setAngle(radians(a) + this.heading);
      index++;
    }
  }

  move(amt) {
    const vel = p5.Vector.fromAngle(this.heading);
    vel.setMag(amt);
    this.pos.add(vel);
  }

  update(x, y) {
    this.pos.set(x, y);
  }

  look(walls) {
    const scene = [];
    for (let i = 0; i < this.rays.length; i++) {		
		const ray = this.rays[i];
		console.log('ray '+ ray);
		let closest = null;
		let record = Infinity;
		let red = null;
		let green = null;
		let blue = null;
	  
      for (let wall of walls) {
        let pt = [];
		pt = ray.cast(wall);
		if (pt) {
		  let d = p5.Vector.dist(this.pos, pt[0]);
          const a = ray.dir.heading() - this.heading;
       //   if (!mouseIsPressed) {
       //     d *= cos(a);
       //   }
          if (d < record) {
            record = d;
            closest = pt[0];
			red = pt[1];
			green = pt[2]; 
			blue = pt[3];
		 }
		 
        }
      }
	  
      if (closest) {
        // colorMode(HSB);
        // stroke((i + frameCount * 2) % 360, 255, 255, 50);
        stroke(red,green,blue);
        line(this.pos.x, this.pos.y, closest.x, closest.y);
      }
      //scene[i] = record;
	  scene[i] = [record, red, green, blue ];
    }
	//var arr = [scene, red, green, blue];
    return scene;
  }

show() {
fill(255,0,0);
ellipse(this.pos.x, this.pos.y, 10);
for (let ray of this.rays) {
      ray.show();
}

  }
  
  
}
