let walls = [];
let ray;
let particle;
let xoff = 0;
let yoff = 10000;

const sceneW = 400;
const sceneH = 400;
let sliderFOV;

function setup() {
  createCanvas(800, 400);
  for (let i = 0; i < 5; i++) {
    let x1 = random(sceneW);
    let x2 = random(sceneW);
    let y1 = random(sceneH);
    let y2 = random(sceneH);
	let red = random(0,255);
	let green = random(0,255);
	let blue = random(0,255);
    walls[i] = new Boundary(x1, y1, x2, y2, red, green, blue);
  }
 // walls.push(new Boundary(0, 0, sceneW, 0));
 // walls.push(new Boundary(sceneW, 0, sceneW, sceneH));
 // walls.push(new Boundary(sceneW, sceneH, 0, sceneH));
 // walls.push(new Boundary(0, sceneH, 0, 0));
  particle = new Particle();
  sliderFOV = createSlider(0, 360, 45);
  sliderFOV.input(changeFOV);
}

function changeFOV() {
  const fov = sliderFOV.value();
  particle.updateFOV(fov);
}

function draw() {
	
  if (keyIsDown(LEFT_ARROW)) {
    particle.rotate(-0.03);
  } else if (keyIsDown(RIGHT_ARROW)) {
    particle.rotate(0.03);
  } else if (keyIsDown(UP_ARROW)) {
    particle.move(1);
  } else if (keyIsDown(DOWN_ARROW)) {
    particle.move(-1);
  }
  background(0);
  
  for (let wall of walls) {
	wall.show();
  }
  
  particle.show();

  const scene = particle.look(walls);
  const w = sceneW / scene.length;
  push();
  translate(sceneW, 0);
  //console.log(scene);
  
  for (let i = 0; i < scene.length; i++) { //scene.length = fov
    noStroke();
    const sq = scene[i][0] * scene[i][0];  // walls
    const wSq = sceneW * sceneW;
    const b = map(sq, 0, wSq, 255, 0);
    const h = map(scene[i][0], 0, sceneW, sceneH, 0);	
	
    fill(scene[i][1],scene[i][2],scene[i][3]);
    rectMode(CENTER);
    rect(i * w + w / 2, sceneH / 2, w + 1, h/2); // this makes the points on the wall become the walls you see
	
  }
  pop();
}
